-- new script file

-- new script file

function OnAfterSceneLoaded(self)
  CreateTriggerTargets(self)
  CreateTriggerSources(self)
end

function OnThink(self)
  if not self.initialized then
    self.initialized = true
    self.active = false
    self.limit = {}
    self.limitTown = 180 -- timer for waveTown - defalut 120
    self.limitFort = 240 -- timer for waveFort - defalut 300
    
    if not self.loaded then
      self.timer = self.limitTown -- setup for first attack
      self.attack = 0
    end
    self.p1 = Citadels.GetPlayer(1)
    
    self.waveTown:LinkToTarget("attTown")
    self.waveFort:LinkToTarget("attFort")
  end
  
  if self.active then
    td = Timer:GetTimeDiff()
    self.timer = self.timer - td
    
    if self.timer <= 0 then
      SendAttack(self)      
    end    
  end
end

function SendAttack(self)
  if self.attack == 0 then
    self.waveTown:TriggerAllTargets()
    self.attack = 1
    self.limitTown = self.limitTown * 1.05
    self.timer = self.limitTown
  elseif self.attack == 1 then
    self.waveFort:TriggerAllTargets()
    self.attack = 0
    self.limitFort = self.limitFort * 0.95
    self.timer = self.limitFort
  end
end

function OnTrigger(self, source, target)
  if target == "deactHandler" then
    self.active = false
  elseif target == "activateHandler" then
    self.active = true
  end
end

function OnSerialize(self, ar)
  if (ar:IsLoading()) and Citadels.GetLoadGameRunning() then
    CreateTriggerSources(self)
    self.loaded = true
    self.timer = ar:Read()
    self.attack = ar:Read()
  elseif (ar:IsSaving()) then
    ar:Write(self.timer)
    ar:Write(self.attack)
  end
end

function CreateTriggerTargets(self)
  self:AddTriggerTarget("deactHandler")
  self:AddTriggerTarget("activateHandler")
end

function CreateTriggerSources(self)
  self:AddTriggerSource("waveTown")
  self:AddTriggerSource("waveFort")
end
